<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();

	$rep_year = date("Y",time());
	$rep_month = date("m",time());

	//Make array for exporting data
	$_SESSION['rep_export'] = array();
	$_SESSION['rep_exp_title'] = $rep_year.'-'.$rep_month.'_loans-pending';

	//Select Pending Loans from LOANS
	$sql_loanpend = "SELECT * FROM loans LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE loans.loanstatus_id = 1 ORDER BY loan_date, loan_no";
	$query_loanpend = mysqli_query($db_link, $sql_loanpend);
	checkSQL($db_link, $query_loanpend);
?>
<html>
	<?PHP includeHead('Pending Loans',1) ?>

	<body>

		<!-- MENU -->
		<?PHP includeMenu(3); ?>
		<div id="menu_main"> <!--
			<a href="loans_search.php">Search</a>
			<a href="loans_act.php">Active Loans</a>
			<a href="loans_pend.php" id="item_selected">Pending Loans</a> -->
            <a href="loans_search.php">Back</a>
			<!--	<a href="loans_securities.php">Loan Securities</a> -->
		</div>
        
                        <!-- tables pagination -->
        <link rel="stylesheet" href="css/paginationTable.css">
        
        <link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">   
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <link rel="stylesheet" href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css">
        <script type="text/javascript" src="http://cdn.datatables.net/1.10.2/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        
    <!-- CONTENT: Pending Loans -->    
    <div class="container2">
        
    <h3 class="actCusttHeading">Pending Loans</h3>
    <div class="exportCdata">
    <form class="export" action="rep_export.php" method="post">
        <!-- Export Button -->	
        <input type="submit" style="background-color: #4682B4 !important; color: #ffffff;" name="export_rep" value="Export" />	
    </form>
    </div>
    <!-- TABLE: Active Customers -->
    <table id="myTable" class="table table-striped table-bordered table-responsive table-hover" >
		<thead>
			<tr> 
            <th scope="col">Loan No</th>
			<th scope="col">Customer</th>
            <th scope="col">Status</th>
			<th scope="col">Loan Period</th>
			<th scope="col">Principal Applied</th>
			<th scope="col">Interest</th>
			<th scope="col">Applied for on</th>  
			</tr>
		</thead>
        <tbody> 
        <?php
            $total_loanpend = 0;
			$count = 0;
			while($row_loanpend = mysqli_fetch_assoc($query_loanpend)){ ?>
		<tr>  
            <td data-label="Loan No">
                <a href="loan.php?lid=<?php echo $row_loanpend['loan_id']; ?>"><?php echo $row_loanpend['loan_no']; ?></a>
            </td>
            
			<td data-label="Customer">
                <?php  echo $row_loanpend['cust_name']; ?> 
                <a href="customer.php?cust=<?php echo $row_loanpend['cust_id'];?>">
                    (<?php echo $row_loanpend['cust_no'];?>)
                </a>
            </td>
            <td data-label="Status">
                <?php echo  $row_loanpend['loanstatus_status']; ?>
            </td>
           
			<td data-label="Loan Period"><?php echo $row_loanpend['loan_period']; ?></td>
            
			<td data-label="Principal Applied">
                <?php echo number_format($row_loanpend['loan_principal']).' '.$_SESSION['set_cur']; ?>
            </td>
			<td data-label="Interest">
                <?php echo number_format(($row_loanpend['loan_repaytotal'] - $row_loanpend['loan_principal'])).' '.$_SESSION['set_cur']; ?>
            </td>
            
            <td data-label="Applied for On"><?php echo date("d.m.Y",$row_loanpend['loan_date']); ?></td>
		</tr> 
        <?php                                                    
            /* Export Customer Data array */                                           
            array_push($_SESSION['rep_export'], array("Loan No." => $row_loanpend['loan_no'], "Customer" => $row_loanpend['cust_name'].' ('.$row_loanpend['cust_no'].')', "Status" => $row_loanpend['loanstatus_status'], "Loan Period" => $row_loanpend['loan_period'], "Principal" => $row_loanpend['loan_principal'], "Interest" => ($row_loanpend['loan_repaytotal'] - $row_loanpend['loan_principal']), "Repay Total" => $row_loanpend['loan_repaytotal'], "Applied for on" => date("d.m.Y",$row_loanpend['loan_date'])));
                                                                  
            $count++;   }	?>
        </tbody>  
    </table>
        <hr class="new1" style="border-top: 1px solid #FB788E;">		
    </div>
        
    <?php include 'views/partial/footer.php'; ?>
    <script src="js/atcMFmainJS.js"></script>
	</body>
<script>
$(document).ready(function(){
    $('#myTable').dataTable();
});
</script>
</html>
